package com.emsi.iir51;

import static androidx.core.app.ActivityCompat.startActivityForResult;

import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class TaskAdapter extends RecyclerView.Adapter<TaskAdapter.TaskVH> {
    ArrayList<Task> data;
    String sessionToken;
    public TaskAdapter(ArrayList<Task> data, String sessionToken) {
        this.sessionToken=sessionToken;
        this.data=data;
    }

    @NonNull
    @Override
    public TaskAdapter.TaskVH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.task_item,parent,false);
        Log.d("TAdapter", "onCreateViewHolder: ");
        return new TaskVH(v);
    }

    @Override
    public void onBindViewHolder(@NonNull TaskAdapter.TaskVH holder, int i) {
        holder.txt.setText(data.get(i).getDesc());
        //holder.img.setImageResource(data.get(i).isDone()?R.drawable.check:R.drawable.uncheck);
        holder.img.setImageResource(data.get(i).isDone()==1?android.R.drawable.checkbox_on_background:android.R.drawable.checkbox_off_background);
        holder.img.setOnClickListener(v -> {
            //DBHelper db = DBHelper.getInstance(v.getContext().getApplicationContext());
            ApiClient.getService().editTask(sessionToken,
                    "edit",
                    data.get(i).getId(),
                    data.get(i).getDesc(),
                    data.get(i).isDone()==1?0:1)
                    .enqueue(new Callback<EditTaskResp>() {
                @Override
                public void onResponse(Call<EditTaskResp> call, Response<EditTaskResp> res) {
                    if(res.isSuccessful()) {
                        EditTaskResp resBody = res.body();
                        if(resBody.getInfo()==1){
                            data.get(i).setDone(data.get(i).isDone()==1?0:1);
                            notifyItemChanged(i);
                        }
                    }else{
                        String errorMessage="";
                        if (res.errorBody() != null) {
                            try {
                                String errorBodyStr = res.errorBody().string();
                                Log.d("Retrofit",errorBodyStr);
                                JsonObject jsonObject = JsonParser.parseString(errorBodyStr).getAsJsonObject();
                                if (jsonObject.has("error") && !jsonObject.get("error").isJsonNull()) {
                                    errorMessage = jsonObject.get("error").getAsString();
                                }
                            } catch (Exception e) {
                                Log.e("Retrofit", "Error parsing error body", e);
                            }
                        }
                        Toast.makeText(holder.img.getContext().getApplicationContext(), errorMessage, Toast.LENGTH_LONG).show();
                    }
                }

                @Override
                public void onFailure(Call<EditTaskResp> call, Throwable t) {
                    Log.d("Retrofit",t.getMessage());
                    Toast.makeText(holder.img.getContext().getApplicationContext(), "Erreur de connexion!", Toast.LENGTH_LONG).show();
                }
            });
            //db.updateTask(data.get(i));
        });
        holder.btnDel.setOnClickListener(v -> {
            //DBHelper db = DBHelper.getInstance(v.getContext().getApplicationContext());
            //db.deleteTask(data.get(i));
            /// TODO: appel API editTask avec cmd=del
            data.remove(i);
            notifyItemRemoved(i);
        });
        holder.btnEdit.setOnClickListener(v -> {
            Intent intent = new Intent(v.getContext(), EditTaskActivity.class);
            intent.putExtra("id", data.get(i).getId());
            intent.putExtra("desc", data.get(i).getDesc());
            intent.putExtra("done", data.get(i).isDone());
            startActivityForResult((AppCompatActivity) v.getContext(),intent,Activity2.FORM_EDIT_CODE,null);
        });
        Log.d("TAdapter", "onBindViewHolder: " + i);
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    public class TaskVH extends RecyclerView.ViewHolder {
        TextView txt;
        ImageView img;
        ImageButton btnDel;
        ImageButton btnEdit;
        public TaskVH(@NonNull View item) {
            super(item);
            txt = item.findViewById(R.id.txt);
            img = item.findViewById(R.id.img);
            btnDel = item.findViewById(R.id.btnDel);
            btnEdit = item.findViewById(R.id.btnEdit);
        }
    }
}
