package com.emsi.iir51;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;


import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.io.IOException;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });
        Log.d("MAct","on est dans onCreate");
        Button btn=findViewById(R.id.btn);
        btn.setOnClickListener(v->{
            EditText txtLogin=findViewById(R.id.txtLogin);
            EditText txtPass=findViewById(R.id.txtPass);
            //i.putExtra("login",txtLogin.getText().toString());
            //i.putExtra("pass",txtPass.getText().toString());
            ApiClient.getService().login(txtLogin.getText().toString(),
                    txtPass.getText().toString()).enqueue(new Callback<LoginResponse>() {
                @Override
                public void onResponse(Call<LoginResponse> call, Response<LoginResponse> res) {
                    if(res.isSuccessful()){
                        LoginResponse user = res.body();
                        Intent i = new Intent(MainActivity.this, Activity2.class);
                        SharedPreferences.Editor editPrefs = getSharedPreferences("mesPrefs", MODE_PRIVATE).edit();
                        editPrefs.putString("sessionToken",user.getSessionToken());
                        editPrefs.putString("nom", user.getNom());
                        editPrefs.putString("prenom", user.getPrenom());
                        editPrefs.commit();
                        //)
                        //editPrefs.putString("pass",txtPass.getText().toString());
                        //editPrefs.commit();
                        startActivity(i);
                    }else{
                        String errorMessage = "Erreur d'authentification!";
                        if (res.errorBody() != null) {
                            try {
                                String errorBodyStr = res.errorBody().string();
                                Log.d("Retrofit",errorBodyStr);
                                JsonObject jsonObject = JsonParser.parseString(errorBodyStr).getAsJsonObject();
                                if (jsonObject.has("error") && !jsonObject.get("error").isJsonNull()) {
                                    errorMessage = jsonObject.get("error").getAsString();
                                }
                            } catch (Exception e) {
                                Log.e("Retrofit", "Error parsing error body", e);
                            }
                        }
                        Toast.makeText(MainActivity.this, errorMessage, Toast.LENGTH_LONG).show();
                    }
                }

                @Override
                public void onFailure(Call<LoginResponse> call, Throwable t) {
                    Log.d("Retrofit",t.getMessage());
                    Toast.makeText(MainActivity.this, "Erreur de connexion!", Toast.LENGTH_LONG).show();
                }
            });

        });
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.d("MAct","on est dans onStart");
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d("MAct","on est dans onResume");

        SharedPreferences prefs = getSharedPreferences("mesPrefs",
                MODE_PRIVATE);
        String sessionToken = prefs.getString("sessionToken", "");
        if(!sessionToken.isEmpty()) {
            ApiClient.getService().loginWithToken(sessionToken).enqueue(new Callback<LoginResponse>() {
                @Override
                public void onResponse(Call<LoginResponse> call, Response<LoginResponse> res) {
                    if (res.isSuccessful()) {
                        LoginResponse user = res.body();
                        Intent i = new Intent(MainActivity.this, Activity2.class);
                        SharedPreferences.Editor editPrefs = getSharedPreferences("mesPrefs", MODE_PRIVATE).edit();
                        editPrefs.putString("sessionToken", user.getSessionToken());
                        editPrefs.putString("nom", user.getNom());
                        editPrefs.putString("prenom", user.getPrenom());
                        editPrefs.commit();
                        //)
                        //editPrefs.putString("pass",txtPass.getText().toString());
                        //editPrefs.commit();
                        startActivity(i);
                    } else {
                        String errorMessage = "Erreur d'authentification!";
                        if (res.errorBody() != null) {
                            try {
                                String errorBodyStr = res.errorBody().string();
                                Log.d("Retrofit", errorBodyStr);
                                JsonObject jsonObject = JsonParser.parseString(errorBodyStr).getAsJsonObject();
                                if (jsonObject.has("error") && !jsonObject.get("error").isJsonNull()) {
                                    errorMessage = jsonObject.get("error").getAsString();
                                }
                            } catch (Exception e) {
                                Log.e("Retrofit", "Error parsing error body", e);
                            }
                        }
                        Toast.makeText(MainActivity.this, errorMessage, Toast.LENGTH_LONG).show();
                    }
                }

                @Override
                public void onFailure(Call<LoginResponse> call, Throwable t) {
                    Log.d("Retrofit", t.getMessage());
                    Toast.makeText(MainActivity.this, "Erreur de connexion!", Toast.LENGTH_LONG).show();
                }
            });
        }
        //if(!login.isEmpty() && !pass.isEmpty()){
        //    Intent i = new Intent(this, Activity2.class);
        //    startActivity(i);
        //    finish();
        //}
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d("MAct","on est dans onPause");
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.d("MAct","on est dans onStop");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("MAct","on est dans onDestroy");
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        Log.d("MAct","on est dans onRestart");
    }
}
