package com.emsi.iir51;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import androidx.annotation.Nullable;

import java.util.ArrayList;

public class DBHelper extends SQLiteOpenHelper {
    private static final int DB_VERSION = 1;
    private static final String DB_NAME = "todotask.db";
    private static final String TABLE_TASK = "tasks";
    private static final String COL_ID = "id";
    private static final String COL_TASK = "description";
    private static final String COL_DONE = "isdone";

    private static DBHelper instance;

    public static DBHelper getInstance(Context context){
        if(instance==null) instance=new DBHelper(context);
        return instance;
    }

    private DBHelper(@Nullable Context context) {
        super(context, DB_NAME, null, DB_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS "+TABLE_TASK+" ("
                +COL_ID+" INTEGER PRIMARY KEY AUTOINCREMENT,"
                +COL_TASK+" TEXT,"
                +COL_DONE+" INTEGER DEFAULT 0)");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int currentV, int newV) {
        db.execSQL("DROP TABLE IF EXISTS "+TABLE_TASK);
        onCreate(db);
    }

    public long addTask(Task t){
        ContentValues row=new ContentValues();
        row.put(COL_TASK,t.getDesc());
        row.put(COL_DONE,t.isDone());
        return getWritableDatabase().insert(TABLE_TASK,null,row);
    }
    public void updateTask(Task t){
        ContentValues row =new ContentValues();
        row.put(COL_TASK,t.getDesc());
        row.put(COL_DONE,t.isDone());
        getWritableDatabase().update(TABLE_TASK,row,
                COL_ID+"=?",new String[]{t.getId()+""});
    }

    public ArrayList<Task> getAllTasks(){
        ArrayList<Task> tasks=new ArrayList<>();
        Cursor c =getReadableDatabase().query(TABLE_TASK,new String[]{COL_ID,COL_TASK,COL_DONE},
                null,null,null,null,null);
        while(c.moveToNext())
            tasks.add(new Task(c.getLong(c.getColumnIndexOrThrow(COL_ID)),
                    c.getString(c.getColumnIndexOrThrow(COL_TASK)),
                    c.getInt(c.getColumnIndexOrThrow(COL_DONE))));
        c.close();
        return tasks;
    }

    public void deleteTask(Task task) {
        getWritableDatabase().delete(TABLE_TASK,COL_ID+"=?",
                new String[]{task.getId()+""});
    }
}
