package com.emsi.iir51;

import android.app.ComponentCaller;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.EdgeToEdge;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Activity2 extends AppCompatActivity {

    public static final int FORM_EDIT_CODE=1;
    ArrayList<Task> tasks=new ArrayList<>();

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.main_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if(item.getItemId()==R.id.action_logout){
            getSharedPreferences("mesPrefs", MODE_PRIVATE).edit().clear().commit();
            Intent i = new Intent(this.getApplicationContext(), MainActivity.class);
            startActivity(i);
            finish();
            return true;
        }else
            return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_2);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });
        //Intent i = getIntent();
        //String login = i.getStringExtra("login");
        //String pass = i.getStringExtra("pass");
        SharedPreferences prefs = getSharedPreferences("mesPrefs",
                MODE_PRIVATE);
        String nom = prefs.getString("nom", "");
        String prenom = prefs.getString("prenom", "");
        String sessionToken = prefs.getString("sessionToken", "");
        if(sessionToken.isEmpty()){
            Intent i = new Intent(this, MainActivity.class);
            startActivity(i);
            finish();
        }

        Toolbar toolbar = findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setTitle(nom+" "+prenom);

        RecyclerView list=findViewById(R.id.list);
        list.setLayoutManager(new LinearLayoutManager(this));
        //DBHelper db=DBHelper.getInstance(this.getApplicationContext());
        //tasks=db.getAllTasks();
        ApiClient.getService().getTasks(sessionToken).enqueue(new Callback<GetTaskResp>() {
            @Override
            public void onResponse(Call<GetTaskResp> call, Response<GetTaskResp> res) {
                if(res.isSuccessful()){
                    GetTaskResp resBody = res.body();
                    tasks=resBody.getTasks();
                    TaskAdapter ta=new TaskAdapter(tasks, sessionToken);
                    list.setAdapter(ta);
                    Log.d("Retrofit", tasks.size()+" "+ tasks.get(0).getDesc());
                }else{
                    String errorMessage = "Erreur d'authentification!";
                    if (res.errorBody() != null) {
                        try {
                            String errorBodyStr = res.errorBody().string();
                            Log.d("Retrofit",errorBodyStr);
                            JsonObject jsonObject = JsonParser.parseString(errorBodyStr).getAsJsonObject();
                            if (jsonObject.has("error") && !jsonObject.get("error").isJsonNull()) {
                                errorMessage = jsonObject.get("error").getAsString();
                            }
                        } catch (Exception e) {
                            Log.e("Retrofit", "Error parsing error body", e);
                        }
                    }
                    Toast.makeText(Activity2.this, errorMessage, Toast.LENGTH_LONG).show();
                }
            }

            @Override
            public void onFailure(Call<GetTaskResp> call, Throwable t) {
                Log.d("Retrofit",t.getMessage());
                Toast.makeText(Activity2.this, "Erreur de connexion!", Toast.LENGTH_LONG).show();
            }
        });
        //for(int j=0; j<10000; j++)
        //    tasks.add(new Task("Task "+j, false));

        FloatingActionButton fab=findViewById(R.id.fab);
        fab.setOnClickListener(v -> {
                getSharedPreferences("mesPrefs", MODE_PRIVATE).edit().clear().commit();
                Intent i = new Intent(this.getApplicationContext(), MainActivity.class);
                startActivity(i);
                finish();
            }
        );

        Button btn=findViewById(R.id.btnAdd);
        EditText txtAdd=findViewById(R.id.txtAdd);
        btn.setOnClickListener(v -> {
            Task t=new Task(txtAdd.getText().toString(),0);
            ApiClient.getService().editTask(sessionToken,
                            "add",
                            0,
                            t.getDesc(),
                            t.isDone())
                    .enqueue(new Callback<EditTaskResp>() {
                        @Override
                        public void onResponse(Call<EditTaskResp> call, Response<EditTaskResp> res) {
                            if(res.isSuccessful()) {
                                EditTaskResp resBody = res.body();
                                if(resBody.getInfo()>0){
                                    t.setId(resBody.getInfo());
                                    tasks.add(0,t);
                                    list.getAdapter().notifyItemInserted(0);
                                    txtAdd.setText("");
                                }
                            }else{
                                String errorMessage="";
                                if (res.errorBody() != null) {
                                    try {
                                        String errorBodyStr = res.errorBody().string();
                                        Log.d("Retrofit",errorBodyStr);
                                        JsonObject jsonObject = JsonParser.parseString(errorBodyStr).getAsJsonObject();
                                        if (jsonObject.has("error") && !jsonObject.get("error").isJsonNull()) {
                                            errorMessage = jsonObject.get("error").getAsString();
                                        }
                                    } catch (Exception e) {
                                        Log.e("Retrofit", "Error parsing error body", e);
                                    }
                                }
                                Toast.makeText(Activity2.this, errorMessage, Toast.LENGTH_LONG).show();
                            }
                        }

                        @Override
                        public void onFailure(Call<EditTaskResp> call, Throwable t) {
                            Log.d("Retrofit",t.getMessage());
                            Toast.makeText(Activity2.this, "Erreur de connexion!", Toast.LENGTH_LONG).show();
                        }
                    });
            //long id=db.addTask(t);
            //t.setId(id);
            //tasks.add(t);
            //ta.notifyItemInserted(tasks.size()-1);
            //txtAdd.setText("");
        });
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull ComponentCaller caller) {
        super.onActivityResult(requestCode, resultCode, data, caller);
        if(requestCode==FORM_EDIT_CODE && resultCode==RESULT_OK)
            Log.d("Formulaire",resultCode+"");
    }
}